AIUserSettingAutoDisableLines = {}
local AIUserSettingAutoDisableLines_mt = Class(AIUserSettingAutoDisableLines, AIUserSetting)

function AIUserSettingAutoDisableLines.new(customMt)
	local self = AIUserSetting.new(customMt or AIUserSettingAutoDisableLines_mt)
	self.identifier = "autoDisableLines"
	self.title = g_i18n:getText("ai_settingAutoDisableLines")
	self.isVineyardSetting = true
	return self
end
function AIUserSettingAutoDisableLines:getIsDisabled(param)
	for _, v in pairs(param) do
		if v.setting.identifier == "showLines" and not v.value then
			return true
		end
	end
	return AIUserSettingAutoDisableLines:superClass():getIsDisabled(param)
end
function AIUserSettingAutoDisableLines:init(old, fieldCourseSettings, mode, init)
	local v = AIUserSettingAutoDisableLines:superClass().init(self, old, fieldCourseSettings, mode, init)
	if AutoDisableSteeringAssistLines ~= nil then
		v.value = AutoDisableSteeringAssistLines.IS_ACTIVE
	else
		v.value = true
	end
	return v
end
function AIUserSettingAutoDisableLines:apply(setting, fieldCourseSettings, mode)
	AutoDisableSteeringAssistLines.IS_ACTIVE = setting.value
end

function AIUserSettingAutoDisableLines:registerXMLPath(schema, key)
	schema:register(XMLValueType.BOOL, string.format("%s#%s", key, self.identifier), self.title)
end

table.insert(AIUserSettings.SETTINGS[AIModeSelection.MODE.STEERING_ASSIST],	AIUserSettingAutoDisableLines.new())
